# Install ORM Tables 
# Copyright 2004, 2005, 2006, 2007, 2008 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# NOTE - this file should be a subset of the "Install ORM Meta-Model Reports" script

# 070806 - first draft of program based on Install Assignment Hours
#       Included draft of tables and objects
# 070807 - added object and report_object
# 070907 - more corrections and additions
# 080130 - several minor changes
# 080519 - separate out ORM Meta-Model Reports
# 081101 - added relational index and relational check

# ORM Diagram, Object Types, Fact Types, Relational Tables, Relational Columns

def DoAdd():
    rt = { 'Name': 'ORM Diagram', 'TableA': 'ORMObjectType', 'TableB': None, 'Also': None, 'AllOrEach': 'each',
           'SuggestedColumns': ',ID;,Name',
           'AdjustRowOption': 'ORMDiagram',  # any value here prevents automatic row creation
           'PanelType': 'ORMDiagram',  # tentative names
           }
    ct = [
    { 'Name': 'ID',           'Label': None,             'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': False, 'Width': 35  },
    { 'Name': 'Name',         'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 100  },
        ]
    Data.AddReportType(rt, ct)

#	ORMObject
#	- ID
#	- ProjectID (Schema)
#	- Name
#	- RefMode = identifier used to refer to instances of object (will standardize it later?)
#	- Type ['Entity', 'Value', 'Objectified']
#       - ORMFactTypeID            # for objectified fact type
#       - Independent [None, '!']  # capture objects that play no roles
#       - Personal [None, 'p']     # refer to object as "who"
#       - DataType                 # type of column in database (will standardize it later?)
#	- Derived [None, '*', '+']
#	- DerivationRule

    rt = { 'Name': 'ORM Object Type', 'TableA': 'ORMObjectType', 'TableB': None, 'Also': None, 'AllOrEach': 'each',
           'SuggestedColumns': ',ID;,Name;,RefMode;,Type;,Independent;,DataType;,Derived;,DerivationRule;,DateAdded' }
    ct = [
    { 'Name': 'ProjectID',    'Label': 'Project\nID',    'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 50  },
    { 'Name': 'Project/Name', 'Label': 'Project\nName',  'DataType': 't', 'AccessType': 'i', 'T': 'A', 'Edit': False, 'Width': 100  },
    { 'Name': 'ID',           'Label': None,             'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': False, 'Width': 35  },
    { 'Name': 'Name',         'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 100  },
    { 'Name': 'RefMode',      'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 100  },
    { 'Name': 'Type',         'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 35  },
    { 'Name': 'ORMFactTypeID', 'Label': 'ORMFactTypeID', 'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 100  },
    { 'Name': 'Independent',  'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 75  },
    { 'Name': 'Personal',     'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 75  },
    { 'Name': 'DataType',     'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 80  },
    { 'Name': 'Derived',      'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 50  },
    { 'Name': 'DerivationRule',  'Label': None,          'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 180  },
    { 'Name': 'Description',  'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 100  },
    { 'Name': 'DateAdded',    'Label': 'Date\nAdded',    'DataType': 'd', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 80  },
        ]
    Data.AddReportType(rt, ct)

#       ORMFact
#	- ID
#	- ProjectID (Schema)
#       - Nary (1 ..)
#       - Unique ['a', 'p', None]  # spanning uniquess constraint
#	- Derived [None, '*', '+']
#	- DerivationRule
#       - ORMFactReadingID         # prefered reading; yes, here for use in rmap
##       - ORMObjectTypeID         # if objectified  ## No, pointer on other end

# in graphic
#       - Rotation ['h', 'v']  # horizontal, vertical
#       - Order ['n', 'r']  # roles display in normal or reversed order


    rt = { 'Name': 'ORM Fact Type', 'TableA': 'ORMFactType', 'TableB': None, 'Also': None, 'AllOrEach': 'each',
           'SuggestedColumns': ',ID;,ORMFactReading/Reading;,RoleSequence;,Name;,Nary;,Unique;,Derived;,DerivationRule;,DateAdded' }
    ct = [
    { 'Name': 'ProjectID',     'Label': 'Project\nID',    'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 50  },
    { 'Name': 'Project/Name',  'Label': 'Project\nName',  'DataType': 't', 'AccessType': 'i', 'T': 'A', 'Edit': False, 'Width': 100  },
    { 'Name': 'ID',            'Label': None,             'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': False, 'Width': 35  },
    # why do I have name? -- New to ORM2 (see ref doc p.6?) - not displayed in diagram, used for naming tables
    { 'Name': 'ORMFactReading/Reading','Label': 'Preferred\nReading','DataType': 't','AccessType': 'i', 'T': 'A', 'Edit': True,  'Width': 120  },
    { 'Name': 'RoleSequence','Label': 'Role\nSequence',   'DataType': 't','AccessType': 'role2', 'T': 'A', 'Edit': False,  'Width': 120,
      'Path': 'ORMFactReading/ORMRoleSequence/ORMRolePosition-ORMRoleSequenceID: ORMRole/ORMObjectType/Name, Seq'},
    { 'Name': 'Name',          'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 100  },
    { 'Name': 'Nary',          'Label': None,             'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': False,  'Width': 40  },
    { 'Name': 'Unique',        'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 50  },
    { 'Name': 'ORMFactReadingID',   'Label': 'ReadingID',    'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 35  },
##    { 'Name': 'ORMObjectTypeID',   'Label': 'ReadingID',    'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 35  },
    { 'Name': 'Derived',       'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 50  },
    { 'Name': 'DerivationRule',  'Label': None,          'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,   'Width': 180  },
    { 'Name': 'Description',   'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 100  },
    { 'Name': 'DateAdded',     'Label': 'Date\nAdded',    'DataType': 'd', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 80  },
        ]
    Data.AddReportType(rt, ct)

# Tables and Columns from Rmap

    rt = { 'Name': 'Relational Table', 'TableA': 'RelationalTable', 'TableB': None, 'Also': None, 'AllOrEach': 'each',
           'SuggestedColumns': ',ID;,Name;,OverrideName;,InUse;,InBase;,TableName;,TableID' }
    ct = [
    { 'Name': 'ID',           'Label': None,             'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': False, 'Width': 35  },

    { 'Name': 'Name',         'Label': 'Table\nName',    'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': False,  'Width': 100  },
    { 'Name': 'RmapName',     'Label': 'Rmap\nName',     'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': False,  'Width': 100  },
    { 'Name': 'BaseName',     'Label': 'Base\nName',     'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': False,  'Width': 100  },
    { 'Name': 'OverrideName', 'Label': 'Override\nName', 'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 100  },

    { 'Name': 'InUse',        'Label': 'In\nUse',        'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': False,  'Width': 50  },
    { 'Name': 'InBase',       'Label': 'In\nBase',       'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': False,  'Width': 50  },
    # source
    { 'Name': 'TableName',    'Label': 'Source',         'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': False,  'Width': 100  },
    { 'Name': 'TableID',      'Label': 'Source\nID',     'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': False, 'Width': 55  },

    { 'Name': 'ProjectID',     'Label': 'Project\nID',    'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': False,  'Width': 50  },
    { 'Name': 'Project/Name',  'Label': 'Project\nName',  'DataType': 't', 'AccessType': 'i', 'T': 'A', 'Edit': False, 'Width': 100  },
    { 'Name': 'DateAdded',     'Label': 'Date\nAdded',    'DataType': 'd', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 80  },
        ]
    Data.AddReportType(rt, ct)

    rt = { 'Name': 'Relational Table / Relational Column', 'TableA': 'RelationalTable', 'TableB': 'RelationalColumn', 'Also': 'Relational Table', 'AllOrEach': 'each',
           'SuggestedColumns': 'Relational Table,ID;Relational Table,Name;,ID;,Seq;,Name;,DataType;,NotNull;,Key;,OverrideName;,OverrideDataType;,OverrideNotNull;,OverrideKey;,InUse;,InBase;,TableName;,TableID' }
    ct = [
    { 'Name': 'ID',           'Label': None,             'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 35  },
#    { 'Name': 'RelationalTableID',     'Label': 'Relational\nTable ID',    'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': False,  'Width': 50  },
    { 'Name': 'RelationalReferenceID', 'Label': 'FK\nID', 'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False,  'Width': 35  },
    { 'Name': 'BaseRelationalReferenceID', 'Label': 'Base\nFK ID', 'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False,  'Width': 35  },

    { 'Name': 'Seq',          'Label': None,             'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 35  },
    { 'Name': 'RmapSeq',      'Label': 'Rmap\nSeq',             'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 35  },
    { 'Name': 'BaseSeq',      'Label': 'Base\nSeq',             'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 35  },
    { 'Name': 'OverrideSeq',  'Label': 'Over\nSeq',             'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': True, 'Width': 35  },

    { 'Name': 'Name',         'Label': 'Column\nName',   'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
    { 'Name': 'RmapName',     'Label': 'Rmap\nName',     'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False,  'Width': 100  },
    { 'Name': 'BaseName',     'Label': 'Base\nName',     'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
    { 'Name': 'OverrideName', 'Label': 'Override\nName', 'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 100  },

    { 'Name': 'DataType',     'Label': 'Column\nData Type',   'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 80  },
    { 'Name': 'RmapDataType', 'Label': 'Rmap\nData Type',   'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 80  },
    { 'Name': 'BaseDataType', 'Label': 'Base\nData Type', 'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 80  },
    { 'Name': 'OverrideDataType', 'Label': 'Override\nData Type', 'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 80  },

    { 'Name': 'NotNull',     'Label': 'Not Null',   'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
    { 'Name': 'RmapNotNull',     'Label': 'Rmap\nNot Null',     'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
    { 'Name': 'BaseNotNull',     'Label': 'Base\nNot Null',     'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
    { 'Name': 'OverrideNotNull', 'Label': 'Override\nNot Null', 'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 100  },

    { 'Name': 'Key',     'Label': 'Column\nKey',   'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 80  },
    { 'Name': 'RmapKey', 'Label': 'Rmap\nKey',     'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 80  },
    { 'Name': 'BaseKey', 'Label': 'Base\nKey',     'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 80  },
    { 'Name': 'OverrideKey', 'Label': 'Override\nKey', 'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 80  },

    { 'Name': 'InUse',        'Label': 'In\nUse',          'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False,  'Width': 50  },
    { 'Name': 'InBase',       'Label': 'In\nBase',         'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False,  'Width': 50  },
    # source
    { 'Name': 'TableName',    'Label': 'Source',        'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
    { 'Name': 'TableID',      'Label': 'Source\nID',    'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 55  },

    { 'Name': 'DateAdded',     'Label': 'Date\nAdded',    'DataType': 'd', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 80  },
        ]
    Data.AddReportType(rt, ct)

    rt = { 'Name': 'Relational Table / Relational Index', 'TableA': 'RelationalTable', 'TableB': 'RelationalIndex', 'Also': 'Relational Table', 'AllOrEach': 'each',
           'SuggestedColumns': 'Relational Table,ID;Relational Table,Name;,ID;,IndexSequence;,Seq;,Name;,Key;,Unique;,OverrideName;,OverrideKey;,OverrideUnique;,InUse;,InBase;,TableName;,TableID' }
    ct = [
    { 'Name': 'ID',           'Label': None,             'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 35  },
#    { 'Name': 'RelationalTableID',     'Label': 'Relational\nTable ID',    'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': False,  'Width': 50  },
    { 'Name': 'IndexSequence','Label': 'Index\nSequence',   'DataType': 't','AccessType': 'role2', 'T': 'B', 'Edit': False,  'Width': 120,
      'Path': 'RelationalIndexColumn-RelationalIndexID: RelationalColumn/Name, Seq'},

    { 'Name': 'Seq',          'Label': None,             'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 35  },
    { 'Name': 'RmapSeq',      'Label': 'Rmap\nSeq',             'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 35  },
    { 'Name': 'BaseSeq',      'Label': 'Base\nSeq',             'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 35  },
    { 'Name': 'OverrideSeq',  'Label': 'Over\nSeq',             'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': True, 'Width': 35  },

    { 'Name': 'Name',         'Label': 'Index\nName',   'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
    { 'Name': 'RmapName',     'Label': 'Rmap\nName',     'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False,  'Width': 100  },
    { 'Name': 'BaseName',     'Label': 'Base\nName',     'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
    { 'Name': 'OverrideName', 'Label': 'Override\nName', 'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 100  },

    { 'Name': 'Key',         'Label': 'Primary\nKey',   'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
    { 'Name': 'RmapKey',     'Label': 'Rmap\nKey',     'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
    { 'Name': 'BaseKey',     'Label': 'Base\nKey',     'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
    { 'Name': 'OverrideKey', 'Label': 'Override\nKey', 'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 100  },

    { 'Name': 'Unique',         'Label': 'Index\nUnique',   'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
    { 'Name': 'RmapUnique',     'Label': 'Rmap\nUnique',     'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
    { 'Name': 'BaseUnique',     'Label': 'Base\nUnique',     'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
    { 'Name': 'OverrideUnique', 'Label': 'Override\nUnique', 'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 100  },

    { 'Name': 'InUse',        'Label': 'In\nUse',          'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False,  'Width': 50  },
    { 'Name': 'InBase',       'Label': 'In\nBase',         'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False,  'Width': 50  },
    # source
    { 'Name': 'TableName',    'Label': 'Source',        'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
    { 'Name': 'TableID',      'Label': 'Source\nID',    'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 55  },

    { 'Name': 'DateAdded',     'Label': 'Date\nAdded',    'DataType': 'd', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 80  },
        ]
    Data.AddReportType(rt, ct)

##    rt = { 'Name': 'Relational Table / Relational Check', 'TableA': 'RelationalTable', 'TableB': 'RelationalCheck', 'Also': 'Relational Table', 'AllOrEach': 'each',
##           'SuggestedColumns': 'Relational Table,ID;Relational Table,Name;,ID;,Seq;,Name;,Check;,OverrideName;,OverrideCheck;,InUse;,InBase;,TableName;,TableID' }
##    ct = [
##    { 'Name': 'ID',           'Label': None,             'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 35  },
###    { 'Name': 'RelationalTableID',     'Label': 'Relational\nTable ID',    'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 50  },
##
##    { 'Name': 'Seq',          'Label': None,             'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 35  },
##    { 'Name': 'RmapSeq',      'Label': 'Rmap\nSeq',             'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 35  },
##    { 'Name': 'BaseSeq',      'Label': 'Base\nSeq',             'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 35  },
##    { 'Name': 'OverrideSeq',  'Label': 'Over\nSeq',             'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': True, 'Width': 35  },
##
##    { 'Name': 'Name',         'Label': 'Column\nName',   'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
##    { 'Name': 'RmapName',     'Label': 'Rmap\nName',     'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False,  'Width': 100  },
##    { 'Name': 'BaseName',     'Label': 'Base\nName',     'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
##    { 'Name': 'OverrideName', 'Label': 'Override\nName', 'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 100  },
##
##    { 'Name': 'Check',     'Label': 'Check',   'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 80  },
##    { 'Name': 'RmapCheck', 'Label': 'Rmap\nCheck', 'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 80  },
##    { 'Name': 'BaseCheck', 'Label': 'Base\nCheck', 'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 80  },
##    { 'Name': 'OverrideCheck', 'Label': 'Override\nCheck', 'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 80  },
##
##    { 'Name': 'InUse',        'Label': 'In\nUse',          'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False,  'Width': 50  },
##    { 'Name': 'InBase',       'Label': 'In\nBase',         'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False,  'Width': 50  },
##    # source
##    { 'Name': 'TableName',    'Label': 'Source',        'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 100  },
##    { 'Name': 'TableID',      'Label': 'Source\nID',    'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': False, 'Width': 55  },
##
##    { 'Name': 'DateAdded',     'Label': 'Date\nAdded',    'DataType': 'd', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 80  },
##        ]
##    Data.AddReportType(rt, ct)

    # this list must match the meta-model
    Data.AddTable('ORMObjectType')
    Data.AddTable('ORMFactType')
    Data.AddTable('ORMFactReading')
    Data.AddTable('ORMRole')
    # Data.AddTable('ORMRoleName')
    Data.AddTable('ORMConstraint')
    Data.AddTable('ORMRoleSequence')
    Data.AddTable('ORMRolePosition')
    Data.AddTable('ORMConstraintConnector')  # temporary - only in diagram
    Data.AddTable('ORMSubtypeConstraint')
    Data.AddTable('ORMSubtypeConstraintConnector')  # temporary - only in diagram
    Data.AddTable('ORMSubtypeConnector')
    Data.AddTable('ORMNote')
    Data.AddTable('ORMNoteConnector')
    Data.AddTable('ORMSampleValue')
    Data.AddTable('ORMSampleRow')
    Data.AddTable('ORMSampleCell')
    Data.AddTable('RelationalIndexColumn')

    # add required data tables
    Data.AddTable('GraphicObject')

    # add required aliases  (It shouldn't take two steps
#    Data.Database['NodeA'] = Data.Database['GraphicObject']  # Does this name work?
#    Data.Database['NodeB'] = Data.Database['GraphicObject']
    Data.AddAlias('NodeA', 'GraphicObject')     # is this the best way to do this?
    Data.AddAlias('NodeB', 'GraphicObject')

#    Data.Database['ORMSubtype'] = Data.Database['ORMObjectType']
    Data.AddAlias('ORMSubtype', 'ORMObjectType')

#    Data.Database['ORMFactReadingAlt'] = Data.Database['ORMFactReading']
    Data.AddAlias('ORMFactReadingAlt', 'ORMFactReading')
    Data.AddAlias('ORMSampleCompositeValue', 'ORMSampleRow')
    Data.AddAlias('RelationalReference', 'RelationalColumn')
    Data.AddAlias('BaseRelationalReference', 'RelationalColumn')
    Data.AddAlias('BaseRelationalTable', 'RelationalTable')

    Data.SetUndo("Install ORM Tables")

DoAdd()
